<?php
/**
 *  Concept WP Theme (Astra Child)
 *
 *
 */

// =============================================================================
// CONSTANTS: Production Env. & Theme Version
// =============================================================================

# CDS_PRODUCTION_ENV
# ------------------------------------------------------------------------------

# define CDS_PRODUCTION_ENV constant is not yet already defined
if ( !defined('CDS_PRODUCTION_ENV') ) {
	# set CDS_PRODUCTION_ENV to false
	define('CDS_PRODUCTION_ENV', false);
}

# CDS_THEME_VERSION
# ------------------------------------------------------------------------------

# if this is the production environment
if ( CDS_PRODUCTION_ENV ) {
	# set the CDS_THEME_VERSION constant
	define('CDS_THEME_VERSION', '1.0.0');
}

# if the CDS_THEME_VERSION constant is not set
if ( !defined('CDS_THEME_VERSION')) {
	# set random CDS_THEME_VERSION constant
	define('CDS_THEME_VERSION', implode('.', array(mt_rand(), mt_rand(), mt_rand())));
}

# THEME_DIRECTORY
# ------------------------------------------------------------------------------

define('THEME_DIRECTORY', get_stylesheet_directory() . '/');

# THEME_DIRECTORY_URI
# ------------------------------------------------------------------------------

define('THEME_DIRECTORY_URI', get_stylesheet_directory_uri() . '/');

// =============================================================================
// INCLUDES: load necessary php files
// =============================================================================

# CDS() system
# ------------------------------------------------------------------------------

//require_once THEME_DIRECTORY . 'system/Boot/boot.php';

// =============================================================================
// INIT: functions.php init callback
// =============================================================================

add_action('init', 'cds_functions_init', 10);

/**
 * CDS Functions Init
 *
 * For best practices, hooks (actions/filters) should be added within the 'init'
 * action hook.
 *
 * @return void
 */
function cds_functions_init()
{
	# is NOT the production environment
	if ( !CDS_PRODUCTION_ENV ) {
		# disable auto update theme
		add_filter('auto_update_theme', '__return_false');
		# disable auto update plugins
		add_filter('auto_update_plugin', '__return_false');
		# disable gravity form notifications
		add_filter('gform_disable_notification', 'cds_disable_gravity_forms_notifications', 10, 4);
	}

	# enqueue scripts
	add_action('wp_enqueue_scripts', 'cds_enqueue_scripts');
}

/**
 * Enqueue Scripts
 *
 * @return void
 */
function cds_enqueue_scripts()
{
	$css = THEME_DIRECTORY_URI . 'css';

	# main style
	wp_enqueue_style('cds-main-css', "$css/main.min.css", array(), CDS_THEME_VERSION, 'all');
}

/**
 * Disable Gravity Form Notifications
 *
 * @param bool $is_disabled
 * @param array $notification
 * @param array $form The Form Object that triggered the notification event.
 * @param array $entry
 *
 * @see https://docs.gravityforms.com/gform_disable_notification/
 *
 * @return bool
 */
function cds_disable_gravity_forms_notifications($is_disabled, $notification, $form, $entry)
{
	# NOT production environment
	if ( CDS_PRODUCTION_ENV !== true) {
		return false;
	}

	return $is_disabled;
}

// END
