<?php
/**
 * Attributes File.
 *
 * @since 1.0.0
 *
 * @package spectra-pro
 */

$arrow_border_attributes      = UAGB_Block_Helper::uag_generate_border_attribute( 'arrow' );
$btn_border_attributes        = UAGB_Block_Helper::uag_generate_border_attribute( 'btn' );
$image_border_attributes      = UAGB_Block_Helper::uag_generate_border_attribute( 'image' );
$main_title_border_attributes = UAGB_Block_Helper::uag_generate_border_attribute( 'mainTitle' );

return array_merge(
	array(
		// Block Requirements.
		'block_id'                           => '',
		'classMigrate'                       => false,
		'igUserName'                         => 'Not Defined',
		// Post Settings.
		'feedLayout'                         => 'grid',
		'postsTotal'                         => 0,
		'postsMax'                           => 15,
		'postsOffset'                        => 0,
		'postOpenIG'                         => true,
		'postDisplayCaption'                 => true,
		// Caption Settings.
		'captionVisibility'                  => 'hover',
		'postCaptionLength'                  => 30,
		'captionDisplayType'                 => 'overlay',
		'postCaptionAlignment'               => 'center center',
		'postDefaultCaption'                 => __( 'No Caption', 'spectra-pro' ),
		'captionPaddingTop'                  => 8,
		'captionPaddingRight'                => 8,
		'captionPaddingBottom'               => 8,
		'captionPaddingLeft'                 => 8,
		'captionPaddingTopTab'               => '',
		'captionPaddingRightTab'             => '',
		'captionPaddingBottomTab'            => '',
		'captionPaddingLeftTab'              => '',
		'captionPaddingTopMob'               => '',
		'captionPaddingRightMob'             => '',
		'captionPaddingBottomMob'            => '',
		'captionPaddingLeftMob'              => '',
		'captionPaddingUnit'                 => 'px',
		'captionPaddingUnitTab'              => 'px',
		'captionPaddingUnitMob'              => 'px',
		'captionGap'                         => 0,
		'captionGapUnit'                     => 'px',
		// Layout Settings.
		'columnsDesk'                        => 3,
		'columnsTab'                         => 3,
		'columnsMob'                         => 3,
		'gridPostGap'                        => 8,
		'gridPostGapTab'                     => '',
		'gridPostGapMob'                     => '',
		'gridPostGapUnit'                    => 'px',
		'gridPostGapUnitTab'                 => 'px',
		'gridPostGapUnitMob'                 => 'px',
		'feedMarginTop'                      => '',
		'feedMarginRight'                    => '',
		'feedMarginBottom'                   => '',
		'feedMarginLeft'                     => '',
		'feedMarginTopTab'                   => '',
		'feedMarginRightTab'                 => '',
		'feedMarginBottomTab'                => '',
		'feedMarginLeftTab'                  => '',
		'feedMarginTopMob'                   => '',
		'feedMarginRightMob'                 => '',
		'feedMarginBottomMob'                => '',
		'feedMarginLeftMob'                  => '',
		'feedMarginUnit'                     => 'px',
		'feedMarginUnitTab'                  => 'px',
		'feedMarginUnitMob'                  => 'px',
		// Layout Specific Settings.
		'carouselStartAt'                    => 0,
		'carouselSquares'                    => false,
		'carouselLoop'                       => true,
		'carouselAutoplay'                   => true,
		'carouselAutoplaySpeed'              => 5000,
		'carouselPauseOnHover'               => true,
		'carouselTransitionSpeed'            => 1000,
		'gridPages'                          => 1,
		'gridPageNumber'                     => 1,
		// Pagination Settings.
		'feedPagination'                     => false,
		'paginateUseArrows'                  => true,
		'paginateUseDots'                    => true,
		'paginateUseLoader'                  => true,
		'paginateLimit'                      => 9,
		'paginateButtonAlign'                => 'center',
		'paginateButtonText'                 => __( 'Load More', 'spectra-pro' ),
		'paginateButtonPaddingTop'           => '',
		'paginateButtonPaddingRight'         => '',
		'paginateButtonPaddingBottom'        => '',
		'paginateButtonPaddingLeft'          => '',
		'paginateButtonPaddingTopTab'        => '',
		'paginateButtonPaddingRightTab'      => '',
		'paginateButtonPaddingBottomTab'     => '',
		'paginateButtonPaddingLeftTab'       => '',
		'paginateButtonPaddingTopMob'        => '',
		'paginateButtonPaddingRightMob'      => '',
		'paginateButtonPaddingBottomMob'     => '',
		'paginateButtonPaddingLeftMob'       => '',
		'paginateButtonPaddingUnit'          => 'px',
		'paginateButtonPaddingUnitTab'       => 'px',
		'paginateButtonPaddingUnitMob'       => 'px',
		// Post Styling.
		'postEnableZoom'                     => true,
		'postZoomType'                       => 'zoom-in',
		'captionBackgroundEnableBlur'        => false,
		'captionBackgroundBlurAmount'        => 0,
		'captionBackgroundBlurAmountHover'   => 5,
		// Caption Typography Styling.
		'captionLoadGoogleFonts'             => false,
		'captionFontFamily'                  => 'Default',
		'captionFontWeight'                  => '',
		'captionFontStyle'                   => 'normal',
		'captionTransform'                   => '',
		'captionDecoration'                  => 'none',
		'captionFontSizeType'                => 'px',
		'captionFontSize'                    => '',
		'captionFontSizeTab'                 => '',
		'captionFontSizeMob'                 => '',
		'captionLineHeightType'              => 'em',
		'captionLineHeight'                  => '',
		'captionLineHeightTab'               => '',
		'captionLineHeightMob'               => '',
		// Pagination Button Typography Styling.
		'loadMoreLoadGoogleFonts'            => false,
		'loadMoreFontFamily'                 => 'Default',
		'loadMoreFontWeight'                 => '',
		'loadMoreFontStyle'                  => 'normal',
		'loadMoreTransform'                  => '',
		'loadMoreDecoration'                 => 'none',
		'loadMoreFontSizeType'               => 'px',
		'loadMoreFontSize'                   => '',
		'loadMoreFontSizeTab'                => '',
		'loadMoreFontSizeMob'                => '',
		'loadMoreLineHeightType'             => 'em',
		'loadMoreLineHeight'                 => '',
		'loadMoreLineHeightTab'              => '',
		'loadMoreLineHeightMob'              => '',
		// Hoverable Styling.
		'captionBackgroundEffect'            => 'none',
		'captionBackgroundEffectHover'       => 'none',
		'captionBackgroundEffectAmount'      => 100,
		'captionBackgroundEffectAmountHover' => 0,
		'captionColor'                       => 'rgba(255,255,255,1)',
		'captionColorHover'                  => 'rgba(255,255,255,1)',
		'captionBackgroundColor'             => 'rgba(0,0,0,0.75)',
		'captionBackgroundColorHover'        => 'rgba(0,0,0,0.75)',
		'overlayColor'                       => 'rgba(0,0,0,0)',
		'overlayColorHover'                  => 'rgba(0,0,0,0)',
		'captionSeparateColors'              => false,
		// Pagination Styling.
		'paginateArrowDistance'              => -24,
		'paginateArrowDistanceUnit'          => 'px',
		'paginateArrowSize'                  => 24,
		'paginateDotDistance'                => '',
		'paginateDotDistanceUnit'            => 'px',
		'paginateLoaderSize'                 => 18,
		'paginateButtonTextColor'            => '',
		'paginateButtonTextColorHover'       => '',
		'paginateColor'                      => '',
		'paginateColorHover'                 => '',
		// Box Shadow Styling.
		'postBoxShadowColor'                 => '',
		'postBoxShadowHOffset'               => 0,
		'postBoxShadowVOffset'               => 0,
		'postBoxShadowBlur'                  => '',
		'postBoxShadowSpread'                => '',
		'postBoxShadowPosition'              => 'outset',
		'postBoxShadowColorHover'            => '',
		'postBoxShadowHOffsetHover'          => 0,
		'postBoxShadowVOffsetHover'          => 0,
		'postBoxShadowBlurHover'             => '',
		'postBoxShadowSpreadHover'           => '',
		'postBoxShadowPositionHover'         => 'outset',
	),
	$arrow_border_attributes,
	$btn_border_attributes,
	$image_border_attributes,
	$main_title_border_attributes,
	array(
		'arrowBorderStyle'             => 'default',
		'arrowBorderTopWidth'          => 1,
		'arrowBorderRightWidth'        => 1,
		'arrowBorderBottomWidth'       => 1,
		'arrowBorderLeftWidth'         => 1,
		'arrowBorderTopLeftRadius'     => 50,
		'arrowBorderTopRightRadius'    => 50,
		'arrowBorderBottomLeftRadius'  => 50,
		'arrowBorderBottomRightRadius' => 50,
		'btnBorderStyle'               => 'default',
		'imageBorderStyle'             => 'default',
		'mainTitleBorderStyle'         => 'default',
		'mainTitleBorderTopWidth'      => 2,
		'mainTitleBorderRightWidth'    => 0,
		'mainTitleBorderBottomWidth'   => 2,
		'mainTitleBorderLeftWidth'     => 0,
	)
);
